package some;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserList {
	private String title1;
	private String title2;
	private String lastUpdate;
	private Map<String, String> numbersMemberMap = new HashMap<String, String>();
	private List<UserInfo> userInfoList = new ArrayList<UserInfo>();
	private UserInfo[] userInfoArr;

	public String toString() {
		StringBuffer buff = new StringBuffer("User\n");
		buff.append("title1=" + getTitle1() + ", ");
		buff.append("title2=" + getTitle2() + ", ");
		buff.append("lasUpdate=" + getLastUpdate() + "\n");

		buff.append("userInfoList\n");
		for (UserInfo userInfo : getUserInfoList()) {
			buff.append(" " + userInfo.toString() + "\n");
		}

		buff.append("userInfoArr\n");
		if (getUserInfoArr() != null) {
			for (UserInfo userInfo : getUserInfoArr()) {
				buff.append(" " + userInfo.toString() + "\n");
			}
		}

		buff.append("\n");
		for (String month : numbersMemberMap.keySet()) {
			Object value = numbersMemberMap.get(month);
			buff.append(String.format(" %s=%s", month, value));
		}
		return buff.toString();
	}

	public void setTitle1(String title1) {
		this.title1 = title1;
	}
	public String getTitle1() {
		return title1;
	}

	public void setTitle2(String title2) {
		this.title2 = title2;
	}
	public String getTitle2() {
		return title2;
	}

	public void setLastUpdate(String lastUpdate) {
		this.lastUpdate = lastUpdate;
	}
	public String getLastUpdate() {
		return lastUpdate;
	}

	public void setNumbersMemberMap(Map<String, String> numbersMemberMap) {
		this.numbersMemberMap = numbersMemberMap;
	}

	public Map<String, String> getNumbersMemberMap() {
		return numbersMemberMap;
	}

	public void setUserInfoList(List<UserInfo> userInfoList) {
		this.userInfoList = userInfoList;
	}

	public List<UserInfo> getUserInfoList() {
		return userInfoList;
	}


	public void setUserInfoArr(UserInfo[] userInfoArr) {
		this.userInfoArr = userInfoArr;
	}

	public UserInfo[] getUserInfoArr() {
		return userInfoArr;
	}


}
